# Anpassung des Dashboards

## Einführung

Das Vertragsverwaltungsdashboard lässt sich in vielen Punkten konfigurieren. Mit der aktuellen Version können Sie die Konfiguration in einer eigenständigen Konfig-Datei vornehmen, die nicht mehr von Aktualisierungen überschrieben wird.

## Zusammensetzung 

Die Konfiguration für das Dasbhoard wird folgendermaßen zum vollständigen Konfigurationsobjekt zusammengesetzt:

1.   Das Dashboard verwendet die Standardeinstellungen der JSON-Konfigurationsdatei im Archiv<br>
<span
style='font-style:italic'>Administration\Business Solutions\contract\ELOapps\Apps\sol.contract.apps.Dashboard\app\Dashboard.config.base.js </span> <br>
Darin befinden sich alle möglichen Konfigurationswerte, die als Basis verwendet werden und überschrieben werden können. Sollten Sie wissen wollen, welche Änderung möglich sind, können Sie hier nachsehen.
2.   Von Business Solutions vorgenommene Einstellungen werden in der Konfiguration in <br>
<span
style='font-style:italic'>Administration/Business Solutions/contract/Configuration/sol.contract.dashboard.config </span>gemacht.
3.   Ändern Sie immer weitere Einstellungen in der Konfiguration in <br>
<span
style='font-style:italic'>Administration/Business Solutions </span><span
style='font-weight:bold;font-style:italic'>Custom</span><span style='font-style:
italic'>/contract/Configuration/sol.contract.dashboard.config</span>. <br>
Die Werte darin überschreiben die Konfiguration von 2. und 1. Wenn dieser Pfad oder die Konfiguration nicht existiert, können Sie ihn anlegen und eine neue JSON-Konfigurationsdatei einpflegen.<br>
&nbsp;
{@img img1.png}
4.   Zuletzt überschreiben Benutzereinstellungen (<span
style='font-style:italic'>ProfileOpts</span>) einzelne Konfigurationseinstellungen, damit der Nutzer seine Einstellung in der Oberfläche über Sitzungen behält. 



<span class="tag_important">Die alte Konfiguration unter <span
style='font-style:italic'>Administration\ELOapps\Configuration</span> wird nicht mehr verwendet. Anpassungen darin müssen Sie bei der Migration auf die neue Version manuell nachziehen.</span>
Dafür ist keine Aktualisierung im WF mehr notwendig. Es reicht aus, das Dashboard neu zu laden.

### Dashboard-Datenpfad ändern

Sie können den Pfad ändern, von dem das Dashboard die Vertragsdaten bekommt. Standardmäßig ist dieser Pfad

> <span
style='font-style:italic'>ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions/contract/Dashboard-Data/</span>

Um den Pfad zu ändern, sollten Sie die Konfiguration nur im Business Solutions Custom Ordner ändern, statt in der App oder im original Business Solutions Ordner. Öffnen (oder ggfs. erstellen) Sie dazu Ihre Konfiguration unter

> <span
style='font-style:italic'>Administration/Business Solutions Custom/contract/Configuration/sol.contract.dashboard.config </span>

und fügen folgende Einstellung ein (mit geändertem Pfad):

    {
       "elo":{
          "ix":{
             "rootPath":"ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions/contract/Configuration/Dashboard-Data/"
          }
      }
    }

Das Dashboard müssen Sie danach im JavaClient oder Browser aktualisieren (rechte Maustaste bzw. F5).

#### Rechtevergabe innerhalb des Dashboard-Data Ordners

Wenn Sie eigene dynamische Ordner erstellen wollen, dann müssen Sie neue dynamische Ordner unter

<span
style='font-style:italic'>Administration\Business Solutions Custom\contract\Configuration\Dashboard-Data</span>

einfügen. Sie können die Suchordner einzeln mit unterschiedlichen Rechten belegen, um bestimmte Gruppen oder Benutzer diese Ordner im Dashboard zur Auswahl zu geben oder auszublenden. <span
style='font-weight:bold'>Natürlich sieht der Benutzer nur diejenigen Verträge, auf die er auch im Archiv Zugriff besitzt bzw. in der Suche findet.</span>

<span class="tag_important">Prüfen Sie die Rechte einmal mit einem beschränkten Benutzer, ob die Sichtbarkeit der entsprechenden dynamischen Ordner im Dashboard so korrekt ist.</span>

<span class="tag_warning">Der Dashboard-Data Ordner innerhalb der Business Solutions (nicht Custom) ist <span
style='text-decoration:underline'>nicht</span> zu Konfiguration bestimmt und seinerseit wieder ein dynamischer Ordner, der sich bei der Konfiguration von Einstellungen und Sicherheitsregeln anders verhält als erwartet. Im Hintergrund arbeitet ein Skript, das den Custom Bereich von Dashboard-Data in den Business Solutions Bereich übernimmt, so dass der <span
style='font-style:italic'>rootPath</span> in der Dashboard-Konfiguration auf den gezeigten Ordner gesetzt werden kann.</span>

<span class="tag_caution">Das Dashboard funktioniert nur, wenn der Benutzer auf mindestens einen Suchordner (normalerweise <span
style='font-style:italic'>Alle Verträge</span>) innerhalb von Dashboard-Data Zugriff hat. Andernfalls zeigt es eine TypeError Skriptmeldung an. </span>


<span class="tag_important">Die Sicherheitseinstellung der Ordner zu Dashboard-Data ist so gewählt, dass das Dashboard sofort funktioniert. Als eingeschränkte Benutzer die Ordner in der Suche zu finden oder das Dashboard öffnen zu können, führt nicht dazu, dass der Benutzer auch die Verträge sehen kann!</span>


### Erweiterung von Spalten für die Vertragsliste

Die Vertragsliste kann durch eigene Indexfelder erweitert werden, indem die Konfigurationsdatei im Archiv angepasst wird. Es werden derzeit keine Map-Felder unterstützt, da dies bei großen Datenmengen zu starken Leistungseinbußen bei der Anzeige führt (lange Wartezeiten).

Die Einstellungen der Spalte sind über das Einstellungsobjekt im JSON im Konfigurationspfad `table.columns` verfügbar.

Dieses JSON Objekt enthält alle Spaltendefinitionen. Es gibt <span
style='font-weight:bold'>voreingestellte Spalten</span>, die immer vorhanden sind und nur angepasst werden können (z.B. ContractNumber). Weiterhin können <span
style='font-weight:bold'>eigene Spalten</span> hinzugefügt werden. Die Reihenfolge der Schlüssel (z.B. ContractNumber) definiert zudem die Reihenfolge der Spalten in der Tabelle. Jedoch kann diese Reihenfolge vom Benutzer in der Oberfläche beliebig geändert werden.

#### Voreingestellte Spalten

Voreingestellte Spalten besitzen einige Felder, die das Verhalten einer Spalte beeinflussen. Spalten werden eindeutig durch den Namen innerhalb des `columns`-Objekts definiert. Derzeit existieren folgende voreingestellte Spalten:

*   ContractNumber
*   ContractName
*   ContractTyped
*   PartnerName
*   ContractDate
*   CompanyName
*   ContractStart
*   ContractEnd
*   ContractCashFlowLocalCurrency
*   ContractRiskClass
*   ContractStatus
*   NextReminderDate
*   NextPossibleTermination

#### Eigene Spalten erzeugen

Eigene Spalten können im Objekt `columns` an die Stelle eingefügt werden, wo sie in der Liste angezeigt werden sollen (die Reihenfolge der Spalten kann jedoch vom Benutzer geändert werden). Jede Spalte wird durch ein Objekt definiert (das Spaltenobjekt), das durch einen eindeutigen Schlüssel definiert wird.

Eigene Spalten können auf zwei Arten erstellt werden. Die erste Art erfordert Kenntnisse der <a
href="http://ui-grid.info/">AngularUI Grid-Komponente</a>. Die Felder des eingefügten Objekts entsprechen dabei den Feldern des UI Grid-Spaltenkonfigurationsobjekts `columnDef`. Indexfelder werden über die Eigenschaft `field` automatisch vom IX angefordert.

Die zweite Art vereinfacht das Erstellen von eigenen Spalten. Dazu wird ein Unterobjekt `solSimple` in das Spaltenobjekt eingefügt. Das Objekt kann die folgenden Eigenschaften enthalten:

<table><thead><tr><td>`columnTitle` - optional</td><td>Optionaler Text, der verwendet wird, um die Spaltenüberschrift zu setzen. Wenn dieser Wert nicht definiert ist, wird die Spaltenüberschrift des Indexkeys aus der Dokumentenmaske verwendet.</td></tr></thead><tbody><tr><td>columTitleLocale` - optional</td><td>Wie columnTitle, jedoch wird ein Übersetzungsschlüssel aus der Datei<span
style='font-weight:bold;font-style:italic'> locale</span> erwartet. </td></tr><tr><td>`fieldName` - zwingend</td><td>Definiert den Indexschlüssel/Gruppennamen, der das Feld der Dokumentenmaske definiert.</td></tr><tr><td>`type` - zwingend</td><td>Definiert den Inhaltstyp für die Liste. Die Eigenschaft kann die folgenden Werte enthalten:<br /><span
style='font-style:italic'>`string`: </span>Die Werte des Vertrags werden unformatiert ausgegeben<br /><span
style='font-style:italic'>`number`: </span>Die Werte des Vertrags werden als Zahl formatiert ausgegeben. Tausendertrennzeichen werden evtl. verwendet (benutzerabhängig).<br /><span
style='font-style:italic'>`date`: </span>Die Werte des Vertrags werden als Datum formatiert ausgegeben so wie der Benutzer es eingestellt hat.<br /><span
style='font-style:italic'>`currency`: </span>Die Werte des Vertrags werden als Währung formatiert ausgegeben.<br /><span
style='font-weight:bold'>NEU</span>: <span style='font-style:italic'>`currencyLocal`: </span>Die Werte der Rechnung werden als Währung formatiert ausgegeben. Dabei wird die jeweilige Währung der Rechnung verwendet. Wenn Sie diesen Wert angeben müssen Sie eine weitere Eigenschaft <span
style='font-style:italic'>currencyField </span>setzen, welche den Gruppenfeldname aufnimmt, der den Währungssymbolname enthält (z.B. CONTRACT_CURRENCY_CODE). </td></tr><tr><td>`allowAggregation` - optional</td><td>Definiert, ob Aggregationen (Summe, Minimum, Maximum, Durchschnitt) der Werte berechnet werden können. Bei gruppierten Spalten wird im Spaltenkopf ein aggregierter Wert angezeigt. <br /><br />Wenn diese Eigenschaft nicht definiert ist, so wird standardmäßig<span
style='font-style:italic'> `false`</span> angenommen, außer der Spaltentyp ist <span
style='font-style:italic'>`number`.</span></td></tr><tr><td>`allowGrouping` - optional</td><td>Definiert, ob die Spalte gruppiert werden kann (über das Spaltenmenü). <br /><br />Wenn diese Eigenschaft nicht definiert ist, so wird standardmäßig<span
style='font-style:italic'> `false`</span> angenommen, außer der Spaltentyp ist<span
style='font-style:italic'> `string`</span> oder<span style='font-style:italic'> `date`.</span></td></tr><tr><td>`isSearchable` - optional</td><td>Definiert, ob die Spalte vom Benutzer standardmäßig durchsucht werden kann. Der Wert ist standardmäßig <span
style='font-style:italic'>`true`.</span> Wenn der Wert auf<span
style='font-style:italic'> `false`</span> gesetzt wird, kann der Benutzer trotzdem über die Listeneinstellung (über das Listenmenü erreichbar) die Spalte wieder durchsuchbar machen.</td></tr></tbody></table>

Außerhalb des `solSimple`-Objekts können alle bereits genannten Eigenschaften (`width`, `minWidth`, `visible` usw.) verwendet werden.

Das folgende Beispiel zeigt, wie eine Spalte für die Vertragsbeispielfeld eingefügt werden kann. Der JSON-Pfad dazu lautet : &quot;table.columns&quot; (sehen Sie dazu auch das Beispiel im Kapitel &quot;Beispielkonfiguration&quot; weiter unten):

    { "table" : { "columns" : {
       …
       "contractExample" : {
         "solSimple" : {
           "fieldName" : "CONTRACT_EXAMPLE",
           "type" : "string"
          },
         "width": 100
       }
      …
    }
    
    
Das Vertragsmanagementdashboard besitzt im Kalender auch eine weitere Liste, welche separat zu konfigurieren ist. Die Umsetzung gestaltet sich dabei genau gleich wie in der Hauptliste.

    { "calendar" : { "dayTable" : { "columns" : {
       …
       "contractExample" : {
         "solSimple" : {
           "fieldName" : "CONTRACT_EXAMPLE",
           "type" : "string"
          },
         "width": 100
       }
      …
    }
    

    
<span class="tag_important"><span
style='font-weight:bold'>Wichtig!:</span> Es können, wie oben beschrieben, nur Indexfelder hinzugefügt werden. Mapfelder werden aus Gründen der Geschwindigkeit nicht unterstützt. </span>

Neben der Konfiguration der Vertragslisten müssen noch die Indexfeldnamen registriert werden. Nutzen Sie dabei die folgende Vorlage und  fügen Sie hinzu und ersetzen Sie Indexfeldnamen nach Notwendigkeit. 

      "ix" : {
         "objKeysHash" : {
          "sordNames" : {
            "CONTRACT_EXAMPLE" : "O_CONTRACT_EXAMPLE"
          },
          "fieldNames" : {
           "O_CONTRACT_EXAMPLE" : "CONTRACT_EXAMPLE"
          }
        }
      }


<span class="tag_important">Achten Sie bei den Feldnamen, ob Sie Ihre Indexfelder mit oder ohne Unterstriche erstellt haben. Der Zusatz &quot;O_&quot; wird immer mit Unterstrich an den Feldnamen angefügt. Wenn im Dashboard in der Spalte der Vertragsliste statt dem übersetzten Feldnamen, der Indexfeldname mit Fragezeichen (?CONTRACT_EXAMPLE) steht, dann konnte der Indexfeldname entweder vom Indexserver nicht gefunden werden oder der Übersetzungsschlüssel (Translation variable) des Indexfeldes (Adminkonsole) ist nicht in die Sprachdateien unter <span
style='font-style:italic'>Administration\Localization\custom</span> eingefügt.</span>

#### Suche in neuen Feldern aktivieren

Um in den neu eingefügten Feldern auch die Suche durchführen zu können, muss der Filter dafür konfiguriert werden. Nutzen Sie dafür die folgende Vorlage, welche Sie um weitere Felder erweitern. Da Arrays beimZusammenführen immer komplett überschrieben werden, müssen alle Standardfelder auch eingefügt werden. 

        "filters":{
          "activeFields":[
             "O_CONTRACT_TYPE",
             "O_PARTNER_NAME",
             "O_CONTRACT_NO",
             "O_CONTRACT_NAME",
             "O_CONTRACT_DATE",
             "O_COMPANY_NAME",
             "O_CONTRACT_STATUS",
             "O_CONTRACT_START",
             "O_CONTRACT_END",
             "O_CONTRACT_CASHFLOW_SUM_LOCAL_CURR",
             "O_CONTRACT_RISK_CLASSIFICATION",
             "O_AUTOMATIC_EXTENSION",
             "O_NEXT_REMINDER_DATE",
             "O_NEXT_POSSIBLE_TERMINATION",
             "O_CONTRACT_EXAMPLE"
          ]
        }
    


#### Schlüsselübersicht

<table><thead><tr><td>Schlüssel</td><td>Werttyp</td><td>Beschreibung</td><td>Default / Beispiel</td></tr></thead><tbody><tr><td>ix.dashboadDataPath</td><td>String</td><td>Definiert den Pfad für die Dashboardaten. Darin enthaltene Ordner werden im Dashboard zur Auswahl angezeigt.<br /></td><td>ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions Custom/contract/Configuration/Dashboard-Data/</td></tr><tr><td>ix.registeredCollectorFunctionConfig.objKeys</td><td>Array aus Strings</td><td>Definiert alle anzuzeigenden Indexfeldnamen (keine Mapfelder)</td><td></td></tr><tr><td>ix.objKeysHash.sordNames<br />ix.objKeysHash.fieldNames</td><td>Array aus Strings</td><td>Definiert Abbildungsvorschriften für Indexfelder zu Feldnamen wie sie von der RF GetChildrenDataCollector zurückgeliefert werden. Feldnamen werden mit einem O_ vorangestellt, um sie von Mapfeldern unterscheiden zu können.</td><td></td></tr><tr><td>table.columns</td><td>Array aus Spaltenobjekte</td><td>Definiert anzuzeigende Spalten in der Tabelle sowie deren Einstellung. </td><td></td></tr><tr><td>indicators.filterSetup</td><td>Objekt aus Filterobjekten</td><td>Definiert Filterobjekte, die als Prozessfilter im Dashboard angezeigt werden sollen. Jeder Schlüsselname entspricht dem Namen eines Eintrags der dynamischen Stichwortliste (dynKWL) von Status (localizedKwls.config).<br />Die Reihenfolge kann durch den Wert `orderId` festgelegt werden oder durch die Reihenfolge der Elemente in der Status dynKWL.<br /><br />Standardmäßig werden alle Statuselemente eingeblendet. Um Statuselemente nicht anzuzeigen müssen Sie diese explizit einfügen und den Wert `visible` auf false setzen.</td><td>Beispiel:<br /><br />    "D": {              <br />     "active": true,             <br />     "visible": true,               <br />     "orderId": 3<br />    }<br /></td></tr></tbody></table>

<span class="tag_important">Änderungen in der Konfiguration können jetzt einfach durch das Neuladen des Dashboards in Kraft gesetzt werden. </span>

    
## Filter einfügen und anpassen
    
    
Um neue Filter einzufügen, bearbeiten Sie die Dashboardkonfiguration und fügen den folgenden Abschnitt &quot;indicators&quot; ein, wie im Beispiel zu sehen ist

    {
       "indicators":{
          "filterSetup":{
             "X":{
             "_$solWatchValues$_" : ["active"], 
             "active" : true,  
    "visible": true,
    "orderId" : 2
            },
          }
       }
    }

Ersetzen Sie dabei das X durch den neuen Schlüsselnamen aus der erweiterten dynamischen Stichwortliste. Um die Reihenfolge zu ändern, können Sie &quot;orderId&quot; auf einen Wert setzen, der größer als 2 ist (Element ganz links). Beachten Sie dabei, dass orderId auch für Elemente gilt, die nicht sichtbar (visible : false) sind, so dass zwei oder mehrere gleiche Werte zu keiner sichtbaren Sortierung führen können. Der Schlüssel &quot;_$solWatchValues$_&quot; gibt an, dass Änderungen am Filterstatus (aktiv oder inaktiv) durch den Benutzer, also &quot;active&quot;-Schlüssel, in den Profiloptionen gespeichert werden soll.

## Beispielkonfiguration

Die Beispielkonfiguration können Sie in die Dashboardkonfiguration unter folgendem Pfad einfügen

<span
style='font-style:italic'>Administration/Business Solutions </span><span
style='font-weight:bold;font-style:italic'>Custom</span><span style='font-style:
italic'>/contract/Configuration/sol.contract.dashboard.config</span>

    {
       "ix":{
          "dashboardDataPath":"ARCPATH[(E10E1000-E100-E100-E100-E10E10E10E00)]:/Business Solutions/contract/Configuration/Dashboard-Data/",
          "objKeysHash":{
             "sordNames":{
                "EXAMPLE_FIELD":"O_EXAMPLE_FIELD"
             },
             "fieldNames":{
                "O_EXAMPLE_FIELD":"EXAMPLE_FIELD"
             }
          }
       },
       "filters":{
          "activeFields":[
             "O_CONTRACT_TYPE",
             "O_PARTNER_NAME",
             "O_CONTRACT_NO",
             "O_CONTRACT_NAME",
             "O_CONTRACT_DATE",
             "O_COMPANY_NAME",
             "O_CONTRACT_STATUS",
             "O_CONTRACT_START",
             "O_CONTRACT_END",
             "O_CONTRACT_CASHFLOW_SUM_LOCAL_CURR",
             "O_CONTRACT_RISK_CLASSIFICATION",
             "O_AUTOMATIC_EXTENSION",
             "O_NEXT_REMINDER_DATE",
             "O_NEXT_POSSIBLE_TERMINATION",
             "O_CONTRACT_EXAMPLE"
          ]
       },
       "table":{
          "columns":{
             "ContractCashFlowLocalCurrency":{
                "cellClass":"currency-tablecell"
             },
             "contractExample":{
                "solSimple":{
                   "fieldName":"CONTRACT_EXAMPLE",
                   "type":"string"
                },
                "width":100
             }
          }
       },
       "indicators":{
          "filterSetup":{
             "X":{
                "_$solWatchValues$_":[
                   "active"
                ],
                "active":true,
                "visible":true,
                "orderId":2
             }
          }
       }
    }


## CSV Export aktivieren
    
Sie können den CSV Export der Tabelle aktivieren, indem Sie folgenden Eintrag vornehmen. Es reicht dabei aus die Eigenschaft &quot;exportCsv&quot; auf true zu setzen. Alle weiteren Eigenschaften sind optional und so voreingestellt wie im Beispiel zu sehen. Dabei gibt filename an, wie der exportierte Dateiname heißen soll; columnSeparator definiert den Spaltentrenner (; für Excel) und forExcel, wenn true, deaktiviert UTF-8 in der CSV-Datei, da Microsoft Excel sonst z.B. Umlaute falsch darstellt.

    {
      "table": {
        &quot;exportCsv&quot; : {
            &quot;enable&quot; : true,
            &quot;filename&quot; : &quot;export_{USER}_{DATE}_{TIME}.csv&quot;,
            &quot;columnSeparator&quot; : &quot;;&quot;,
            &quot;forExcel&quot; : true
          }
      }
    }
    
Im Beispiel wird die Haupttabelle erweirtert, es können jedoch alle Tabellen in den JSON Configs angepasst werden, die die Eigenschaft &quot;columns&quot; besitzen wie z.B. calendar.dayTable. 
